/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import javax.swing.SwingWorker;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;

public class AuthlibDLWorker
extends SwingWorker<Boolean, Void> {
    protected String status;
    protected String reqVersion;
    protected File binDir;
    protected String authlibVersion;
    protected URL jarURLs;

    public AuthlibDLWorker(String DLFolder, String authver) {
        this.binDir = new File(DLFolder);
        this.authlibVersion = authver;
        this.status = "";
    }

    @Override
    protected Boolean doInBackground() {
        Benchmark.start("Authlib");
        Logger.logDebug("Loading Authlib...");
        if (!this.binDir.exists()) {
            this.binDir.mkdirs();
        }
        if (!this.downloadJars()) {
            Logger.logError("Authlib Download Failed");
            if (!new File(this.binDir + File.separator + "authlib-" + this.authlibVersion + ".jar").exists()) {
                return false;
            }
            Logger.logInfo("Local Authlib copy exists: trying to load it anyway");
        }
        this.setStatus("Adding Authlib to Classpath");
        Logger.logInfo("Adding Authlib to Classpath");
        return this.addToClasspath(this.binDir + File.separator + "authlib-" + this.authlibVersion + ".jar");
    }

    protected boolean addToClasspath(String location) {
        File f = new File(location);
        try {
            if (f.exists()) {
                this.addURL(f.toURI().toURL());
                this.getClass();
                Class.forName("com.mojang.authlib.exceptions.AuthenticationException");
                this.getClass();
                Class.forName("com.mojang.authlib.Agent");
                this.getClass();
                Class.forName("com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService");
                this.getClass();
                Class.forName("com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication");
            } else {
                Logger.logError("Authlib file does not exist");
            }
        }
        catch (Throwable t) {
            Logger.logError(t.getMessage(), t);
            return false;
        }
        LaunchFrame.canUseAuthlib = true;
        Benchmark.logBenchAs("Authlib", "Authlib DL Worker Init");
        return true;
    }

    public void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)this.getClass().getClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            Logger.logWarn(t.getMessage(), t);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    protected boolean downloadJars() {
        try {
            this.jarURLs = new URL("https://libraries.minecraft.net/com/mojang/authlib/" + this.authlibVersion + "/authlib-" + this.authlibVersion + ".jar");
        }
        catch (MalformedURLException e) {
            Logger.logError(e.getMessage(), e);
            return false;
        }
        double totalDownloadSize = 0.0;
        double totalDownloadedSize = 0.0;
        int[] fileSizes = new int[1];
        String hash = "";
        for (int i = 0; i < 1; ++i) {
            try {
                HttpURLConnection conn = (HttpURLConnection)this.jarURLs.openConnection();
                conn.setRequestProperty("Cache-Control", "no-transform");
                hash = conn.getHeaderField("ETag").replace("\"", "");
                fileSizes[i] = conn.getContentLength();
                conn.disconnect();
                totalDownloadSize += (double)fileSizes[i];
                continue;
            }
            catch (Exception e) {
                Logger.logWarn("Authlib checksum download failed", e);
                return false;
            }
        }
        boolean downloadSuccess = false;
        if (hash != null && !hash.equals("") && new File(this.binDir, this.getFilename(this.jarURLs)).exists()) {
            try {
                if (hash.toLowerCase().equals(DownloadUtils.fileMD5(new File(this.binDir, this.getFilename(this.jarURLs))).toLowerCase())) {
                    Logger.logInfo("Local Authlib Version is good, skipping Download");
                    return true;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        int attempt = 0;
        int attempts = 5;
        while (!downloadSuccess && attempt < 5) {
            try {
                int readLen;
                FileOutputStream outStream;
                String jarFileName;
                Logger.logDebug("Connecting.. Try " + ++attempt + " of " + 5 + " for: " + this.jarURLs.toURI());
                URLConnection dlConnection = this.jarURLs.openConnection();
                if (dlConnection instanceof HttpURLConnection) {
                    dlConnection.setRequestProperty("Cache-Control", "no-cache, no-transform");
                    dlConnection.connect();
                }
                if (new File(this.binDir, jarFileName = this.getFilename(this.jarURLs)).exists()) {
                    new File(this.binDir, jarFileName).delete();
                }
                InputStream dlStream = dlConnection.getInputStream();
                try {
                    outStream = new FileOutputStream(new File(this.binDir, jarFileName));
                }
                catch (Exception e) {
                    downloadSuccess = false;
                    Logger.logError("Error while opening authlib file for writing. Check your FTB installation location write access", e);
                    break;
                }
                this.setStatus("Downloading " + jarFileName + "...");
                byte[] buffer = new byte[24000];
                int currentDLSize = 0;
                while ((readLen = dlStream.read(buffer, 0, buffer.length)) != -1) {
                    outStream.write(buffer, 0, readLen);
                    currentDLSize += readLen;
                    int prog = (int)((totalDownloadedSize += (double)readLen) / totalDownloadSize * 100.0);
                    if (prog > 100) {
                        prog = 100;
                    } else if (prog < 0) {
                        prog = 0;
                    }
                    this.setProgress(prog);
                }
                dlStream.close();
                outStream.close();
                if (!(dlConnection instanceof HttpURLConnection) || currentDLSize != fileSizes[0] && fileSizes[0] > 0) continue;
                downloadSuccess = true;
            }
            catch (Exception e) {
                downloadSuccess = false;
                Logger.logWarn("Connection failed, trying again", e);
            }
        }
        return downloadSuccess;
    }

    protected String getFilename(URL url) {
        String string = url.getFile();
        if (string.contains("?")) {
            string = string.substring(0, string.indexOf(63));
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    protected void setStatus(String newStatus) {
        String oldStatus = this.status;
        this.status = newStatus;
        this.firePropertyChange("status", oldStatus, newStatus);
    }

    public String getStatus() {
        return this.status;
    }
}

